#ifndef VPRENDERMAN_H__
#define VPRENDERMAN_H__

enum
{
	ID_QUALITY										= 10000,

	GROUP_SAMPLING									= 11004,
	GROUP_GEOMETRY									= 11005,

	CINEMAN_PIXELSAMPLESX							= 10005,	// LONG
	CINEMAN_PIXELSAMPLESY							= 10006,	// LONG
	CINEMAN_SHADINGRATE								= 10301,	// Real (Attribute)
	CINEMAN_PIXELFILTER								= 10010,	// LONG
		CINEMAN_PIXELFILTER_BOX						= 0,
		CINEMAN_PIXELFILTER_TRIANGLE				= 1,
		CINEMAN_PIXELFILTER_CATMULLROM				= 2,
		CINEMAN_PIXELFILTER_GAUSSIAN				= 3,
		CINEMAN_PIXELFILTER_SINC					= 4,
	CINEMAN_XFILTERWIDTH							= 10011,	// Real
	CINEMAN_YFILTERWIDTH							= 10012,	// Real

	CINEMAN_SHADINGINTERPOLATION					= 10302,	// LONG (Attribute)
		CINEMAN_SHADINGINTERPOLATION_CONSTANT		= 0,
		CINEMAN_SHADINGINTERPOLATION_SMOOTH			= 1,
	CINEMAN_SIDES									= 10303,	// LONG (Attribute)


	ID_FEATURES										= 11000,

	GROUP_MOTIONBLUR								= 11001,
	GROUP_DOF										= 11002,
	GROUP_RAYTRACING								= 11003,

	CINEMAN_MOTIONBLUR								= 10003,	// LONG (Transform Only, Transform & Deform)
		CINEMAN_MOTIONBLUR_NONE						= 0,
		CINEMAN_MOTIONBLUR_TRANSFORM				= 1,
		CINEMAN_MOTIONBLUR_TRANSDEFORM				= 2,
		CINEMAN_MOTIONBLUR_DEFORM					= 3,
	CINEMAN_MBLURLENGTH								= 10004,	// Real
	//CINEMAN_MOTIONFACTOR							= 10304,	// Real (Attribute -> same id as in Tribattributes)

	CINEMAN_DOF										= 10020,	// Bool
	CINEMAN_FOCALDISTANCE							= 10021,	// Real
	CINEMAN_FROMCAMERA								= 10022,	// Bool
	CINEMAN_FOCALLENGTH								= 10023,	// Real
	CINEMAN_FSTOP									= 10024,	// Real

//	CINEMAN_RAYSHADOWBIAS							= 10025,	// Real



	ID_GLOBALILLUMINATION							= 90000,

	GROUP_GIQUALITY 								= 11006,
	GROUP_GICACHE									= 11007,
	GROUP_ENVIRONMENT								= 11008,


	CINEMAN_GI_ENABLE								= 10100,
	// PRMAN GI OPTIONS


	ID_TRANSLATION									= 70000,

	GROUP_PATHS										= 11011,
	GROUP_RIB										= 11012,
	GROUP_TRANSLATION								= 11013,


//	CINEMAN_HYPERNURBS								= 10051,	// LONG
//		CINEMAN_HYPERNURBS_POLYMESH					= 0,
//		CINEMAN_HYPERNURBS_CATMULLCLARK 			= 1,
//	CINEMAN_METABALLS								= 10053,	// LONG
//		CINEMAN_METABALLS_POLYMESH					= 0,
//		CINEMAN_METABALLS_BLOBBYS					= 1,
//	CINEMAN_INSTANCES								= 10052,	// LONG
//		CINEMAN_INSTANCES_RAWGEOMETRY				= 0,
//		CINEMAN_INSTANCES_READARCHIVE				= 1,

	CINEMAN_RIBSTYLE								= 70001,
		CINEMAN_RIBSTYLE_ARCHIVES					= 0,
		CINEMAN_RIBSTYLE_FLAT						= 1,
	CINEMAN_RIBFORMAT								= 70002,
		CINEMAN_RIBFORMAT_ASCII						= 0,
		CINEMAN_RIBFORMAT_BINARY						= 1,
		CINEMAN_RIBFORMAT_GZIP_ASCII					= 2,
		CINEMAN_RIBFORMAT_GZIP_BINARY				= 3,


	ID_ATMOSPHERE									= 20000,
	CINEMAN_ATMOSPHERE_SAMPLING						= 20020,	// LONG
		CINEMAN_ATMOSPHERE_SAMPLING_AVERAGE			= 0,
		CINEMAM_ATMOSPHERE_SAMPLING_USEMIN			= 1,
		CINEMAN_ATMOSPHERE_SAMPLING_USEMAX			= 2,
		CINEMAN_ATMOSPHERE_SAMPLING_SPECIFY			= 3,
	CINEMAN_ATMOSPHERE_STEPSIZE						= 20021,	// Real


		ID_SETTINGS										= 40000,
//	CINEMAN_RENDERER								= 40001,
//			CINEMAN_RENDERER_AIR					= 0,
//			CINEMAN_RENDERER_PRMAN					= 1,
//			CINEMAN_RENDERER_3DELIGHT				= 2,
	//CINEMAN_COMMANDOPTION							= 40002,	// String
	CINEMAN_SHADERPATH								= 40010,	// String
	CINEMAN_TEXTUREPATH                 			= 40011,	// String
	CINEMAN_ARCHIVEPATH								= 40012,	// String
	CINEMAN_PROCEDURALPATH							= 40013,	// String
	CINEMAN_DISPLAYPATH								= 40014,	// String

	GROUP_PLATFORMS									= 40015,
	CINEMAN_DIRMAPS									= 40016,	// PathList

	CINEMAN_DISPLAYPRESETS							= 30001,	// LONG (virtual)
		CINEMAN_DISPLAY_CUSTOM						= 0,
		CINEMAN_DISPLAY_CINEMAN						= 1,
		CINEMAN_DISPLAY_FRAMEBUFFER					= 2,
		CINEMAN_DISPLAY_FILE						= 3,
	CINEMAN_DISPLAY									= 30002,	// String


	CINEMAN_EXPORTMAINRIB							= 30112,	// Bool
	CINEMAN_EXPORTSHADERS							= 30109,	// Bool
	CINEMAN_EXPORTCOMPILESHADERS					= 30102,	// Bool
	CINEMAN_EXPORTTEXTURES							= 30108,	// Bool
	CINEMAN_EXPORTMAKETEXTURES						= 30103,	// Bool
	CINEMAN_EXPORTARCHIVES							= 30104,	// Bool
	CINEMAN_FLATDIRECTORY							= 30110,	// Bool (no subdirs like archives, textures, shaders)
	CINEMAN_COPYAUXFILES							= 30111,	// Bool (copy over shader headers, default shaders, dsos, display drivers)


	// HIDDEN STUFF!
	CINEMAN_ONLYSELECTED							= 30106,	// Bool
	CINEMAN_STARTRENDER								= 30107,	// Bool
	CINEMAN_ROOTFILE 								= 60000,	// String/Filename
	CINEMAN_EXPORTAS								= 60001,	// LONG
		CINEMAN_EXPORTAS_FULLSCENE					= 0,
		CINEMAN_EXPORTAS_ARCHIVEGEOANDLIGHTS		= 1,
		CINEMAN_EXPORTAS_ARCHIVEGEOONLY				= 2,
		CINEMAN_EXPORTAS_ARCHIVELIGHTSONLY			= 3,
	CINEMAN_DISPLAYNAME								= 60002,	// String
	CINEMAN_DISPLAYDRIVER							= 60003,		// String
	CINEMAN_EXPORTPROGRESS							= 60004,	// Bool
	CINEMAN_JOBFILE								= 60006,
		CINEMAN_JOBFILE_NONE						= 0,
		CINEMAN_JOBFILE_DOSBATCH					= 1,
		CINEMAN_JOBFILE_SHELLSCRIPT					= 2,

	CINEMAN_DIRTY									= 60005,	// LONG (hidden dirty counter)


	ID_ADVANCEDOPTIONS								= 80000,

	GROUP_STRATEGY									= 11009,
	GROUP_MEMORY									= 11010,


	//
	// PRMan
	//
	//
	// The Renderer Specific Parameters reserve the space 100000 upwards
	// every renderer starts at 1x0000 for options
	// every renderer starts at 1x1000 for attributes
	// the second digit is the renderer, 0 for prman, 1 for air, 2 for 3Delight
	// corresponding options/attributes should have corresponding ids
	// Attribute IDs have to be the same as in the Attribute Tag
	//

	// PRMan Options
	CINEMAN_PRM_LIMITS_BUCKETSIZEX					= 100001,	// LONG
	CINEMAN_PRM_LIMITS_BUCKETSIZEY					= 100002,	// LONG
	// CINEMAN_PRM_LIMITS_LOCKBUCKETSIZE			= 100003,	// Bool
	// Bucket order?
	CINEMAN_PRM_LIMITS_GRIDSIZE						= 100008,	// LONG
	CINEMAN_PRM_LIMITS_TEXTUREMEMORY				= 100020,	// LONG
	CINEMAN_PRM_LIMITS_BRICKMEMORY					= 100021,	// LONG (PRMan only)
	CINEMAN_PRM_LIMITS_GEOCACHEMEMORY				= 100022,	// LONG (PRMan only)
	CINEMAN_PRM_LIMITS_ZTHRESHOLD					= 100031,	// Color (PRMan only)
	CINEMAN_PRM_LIMITS_OTHRESHOLD					= 100032,	// Color (PRMan only)
	CINEMAN_PRM_LIMITS_EXTREMEDISPLACEMENT			= 100033,	// Bool

	CINEMAN_PRM_MOTIONFACTOR						= 100060,	// Real	(Attribute)
	CINEMAN_PRM_FOCUSFACTOR							= 100062,	// Real (Attribute)

	CINEMAN_PRM_TRACE_MAXDEPTH						= 100050,	// LONG
	CINEMAN_PRM_TRACE_BIAS							= 100053,	// Real (Attribute)
	CINEMAN_PRM_TRACE_SAMPLEMOTION					= 100054,	// Bool (Attribute)
	CINEMAN_PRM_TRACE_DISPLACEMENTS					= 100055,	// Bool (Attribute)
	CINEMAN_PRM_TRACE_MAXDIFFUSEDEPTH				= 100057,	// LONG (Attribute)
	CINEMAN_PRM_TRACE_MAXSPECULARDEPTH				= 100058,	// LONG (Attribute)
	CINEMAN_PRM_TRACE_SPECULARTHRESHOLD				= 100056,	// Real (Angle!)


	CINEMAN_PRM_GI									= 100070,
		CINEMAN_PRM_GI_NONE							= 0,
		CINEMAN_PRM_GI_POINTCOLORBLEEDING			= 1,
	CINEMAN_PRMAN_GI_CAMERA							= 100071,
	CINEMAN_PRMAN_GI_RESOLUTION						= 100072,
			CINEMAN_PRMAN_GI_RESOLUTION_FULL		= 1,
			CINEMAN_PRMAN_GI_RESOLUTION_HALF		= 2,
			CINEMAN_PRMAN_GI_RESOLUTION_QUARTER		= 4,
	CINEMAN_PRMAN_GI_SHADINGRATE 					= 100073,
	CINEMAN_PRMAN_GI_BOUNCES						= 100074,
	CINEMAN_PRMAN_GI_MAXSOLIDANGLE					= 100075,
	CINEMAN_PRMAN_GI_CLAMP							= 100076,
	CINEMAN_PRMAN_GI_SORTBLEEDING					= 100077,
	CINEMAN_PRMAN_GI_SIDES							= 100078,
		CINEMAN_PRMAN_GI_SIDES_FRONT				= 0,
		CINEMAN_PRMAN_GI_SIDES_BACK					= 1,
		CINEMAN_PRMAN_GI_SIDES_BOTH					= 2,
	CINEMAN_PRMAN_GI_INTENSITY						= 100079,

	CINEMAN_PRM_GI_MAXERROR						= 100101,	// Real (Attribute)
	CINEMAN_PRM_GI_MAXPIXELDIST						= 100102,	// Real (Attribute)


	ID_SPOOL										= 100100,
	CINEMAN_SPOOL_USE								= 100101,	// LONG
		CINEMAN_SPOOL_USE_NEVER						= 0,
		CINEMAN_SPOOL_USE_EXTERNALONLY				= 1,
		CINEMAN_SPOOL_USE_ALWAYS					= 2,
	CINEMAN_SPOOL_RIBGENERATION						= 100109,
		CINEMAN_SPOOL_RIBGENERATION_IMMEDIATE		= 0,
		CINEMAN_SPOOL_RIBGENERATION_DEFERRED		= 1,
		CINEMAN_SPOOL_RIBGENERATION_DISTRIBUTED		= 2,
	CINEMAN_SPOOL_JOBCHUNKSIZE						= 100110,
	CINEMAN_SPOOL_SPOOLER							= 100106,
		CINEMAN_SPOOL_SPOOLER_DOSBATCH				= 0,
		CINEMAN_SPOOL_SPOOLER_UNIXSHELLSCRIPT		= 1,
		CINEMAN_SPOOL_SPOOLER_ALFRED				= 2,
	CINEMAN_SPOOL_RENDERER							= 100107,
		CINEMAN_SPOOL_RENDERER_CUSTOM				= 0,
		CINEMAN_SPOOL_RENDERER_PRMAN				= 1,
		CINEMAN_SPOOL_RENDERER_NETRENDER			= 2,
		CINEMAN_SPOOL_RENDERER_AIR					= 3,
		CINEMAN_SPOOL_RENDERER_VORTEX				= 4,
	CINEMAN_SPOOL_CUSTOMRENDERER					= 100108,
	CINEMAN_PRM_ALFRED_MINHOSTS						= 100103,	// LONG
	CINEMAN_PRM_ALFRED_MAXHOSTS						= 100104,	// LONG
	CINEMAN_PRM_ALFRED_COMPUTELOCATION				= 100105,	// LONG
		CINEMAN_PRM_ALFRED_COMPUTELOCATION_LOCAL	= 0,
		CINEMAN_PRM_ALFRED_COMPUTELOCATION_REMOTE	= 1,


	//
	// AIR
	//
	// Options
	CINEMAN_AIR_LIMITS_BUCKETSIZEX					= 110001,	// LONG
	CINEMAN_AIR_LIMITS_BUCKETSIZEY					= 110002,	// LONG
	CINEMAN_AIR_RENDER_BUCKETORDER					= 110004,	// LONG
		CINEMAN_AIR_RENDER_BUCKETORDER_VERTICAL		= 0,
		CINEMAN_AIR_RENDER_BUCKETORDER_HORIZONTAL	= 1,
		CINEMAN_AIR_RENDER_BUCKETORDER_SPIRAL		= 2,

	CINEMAN_AIR_LIMITS_TEXTUREMEMORY				= 110020,	// LONG

	CINEMAN_AIR_RENDER_EDGEMASK						= 110040,	// Bool
	CINEMAN_AIR_RENDER_TRUEDISPLACEMENT					= 110041,	// Bool (Attribute)
	CINEMAN_AIR_RENDER_TRIANGLEDISPLACEMENT					= 110042,	// Bool (Attribute)
//	CINEMAN_AIR_RENDER_NORMALDISPLACEMENT

	CINEMAN_AIR_TRACE_MAXDEPTH						= 110050,	// LONG
	CINEMAN_AIR_TRACE_MINWEIGHT						= 110051,	// Real
	CINEMAN_AIR_TRACE_REDUCESAMPLES					= 110052,	// Real
	CINEMAN_AIR_TRACE_BIAS							= 110053,	// Real (Attribute)
	CINEMAN_AIR_TRACE_MOTIONBLUR					= 110054,	// Bool (Attribute)
	CINEMAN_AIR_TRACE_DISPLACEMENTS					= 110055,	// Bool (Attribute)

	CINEMAN_AIR_MOTIONFACTOR						= 110060,	// Real	(Attribute)
	CINEMAN_AIR_FLATNESS							= 110061,	// Real (Attribute)

	// Global Illumination Options
	CINEMAN_AIR_GI_PREPASS							= 110105,	// Bool
	CINEMAN_AIR_GI_PREPASSFACTOR					= 110106,	// Real
	CINEMAN_AIR_GI_MAXERROR							= 110101,	// Real (Attribute)
	CINEMAN_AIR_GI_MAXPIXELDIST						= 110102,	// Real (Attribute)
	CINEMAN_AIR_GI_NSAMPLES							= 110103,	// LONG (Attribute)
	CINEMAN_AIR_GI_MAXBOUNCE						= 110104,	// LONG
	CINEMAN_AIR_GI_ADAPTIVESAMPLING					= 110107,	// Bool (Attribute)
	CINEMAN_AIR_GI_MAXVARIANCE						= 110108,	// Real
	CINEMAN_AIR_GI_MOVING							= 110112,	// Bool
	CINEMAN_AIR_GI_SAVEFILE							= 110110,	// Filename
	CINEMAN_AIR_GI_SEEDFILE							= 110111,	// Filename
	CINEMAN_AIR_GI_BACKGROUND						= 110121,	// Vector
	CINEMAN_AIR_GI_ENVNAME							= 110113,	// String
	CINEMAN_AIR_GI_ENVSTRENGTH						= 110114,	// Real
	CINEMAN_AIR_GI_ENVBLUR							= 110115,	// Real
	CINEMAN_AIR_GI_MAXHITDIST						= 110116,	// Real (Attribute)

	// Caustic Options

	// Ambient Occlusion Options
	CINEMAN_AIR_AO_PREPASS							= 110201,	// Bool
	CINEMAN_AIR_AO_PREPASSFACTOR					= 110202,	// Real
	CINEMAN_AIR_AO_MAXVARIANCE						= 110203,	// Real

	CINEMAN_AIR_AO_SAVEFILE							= 110204,	// Filename
	CINEMAN_AIR_AO_SEEDFILE							= 110205,	// Filename



	//
	// 3Delight
	//
	CINEMAN_3DL_LIMITS_BUCKETSIZEX					= 120001,	// LONG
	CINEMAN_3DL_LIMITS_BUCKETSIZEY					= 120002,	// LONG
	CINEMAN_3DL_RENDER_BUCKETORDER					= 120004,	// LONG
		CINEMAN_3DL_RENDER_BUCKETORDER_HORIZONTAL	= 0,
		CINEMAN_3DL_RENDER_BUCKETORDER_ZIGZAG		= 1,
		CINEMAN_3DL_RENDER_BUCKETORDER_VERTICAL		= 2,
		CINEMAN_3DL_RENDER_BUCKETORDER_SPIRAL		= 3,
		CINEMAN_3DL_RENDER_BUCKETORDER_CIRCLE		= 4,
		CINEMAN_3DL_RENDER_BUCKETORDER_RANDOM		= 5,
	CINEMAN_3DL_LIMITS_GRIDSIZE						= 120008,	// LONG
	CINEMAN_3DL_LIMITS_EYESPLITS					= 120005,	// LONG
	CINEMAN_3DL_LIMITS_TEXTUREMEMORY				= 120006,	// LONG
	CINEMAN_3DL_LIMITS_OTHRESHOLD					= 120007,

	CINEMAN_3DL_MOTIONFACTOR						= 120060,	// Real	(Attribute)
	CINEMAN_3DL_FOCUSFACTOR							= 120062,	// Real (Attribute)

	CINEMAN_3DL_TRACE_MAXDEPTH						= 120050,	// LONG
	CINEMAN_3DL_TRACE_BIAS							= 120053,	// Real (Attribute)
	CINEMAN_3DL_TRACE_SAMPLEMOTION					= 120054,	// Bool (Attribute)
	CINEMAN_3DL_TRACE_DISPLACEMENTS					= 120055,	// Bool (Attribute)

	CINEMAN_3DL_GI_SHADINGRATE						= 120102,	// Real (Attribute)
	CINEMAN_3DL_GI_MAXERROR							= 120101	// Real (Attribute)

};

#endif // VPRENDERMAN_H__
